<!-- <nav> -->
- [Akka](../index.html)
- [Understanding](index.html)

<!-- </nav> -->

# Understanding

This content here introduces key [concepts](concepts.html) to be aware of when developing Akka applications and services.

Everything in Akka is based on the [fundamental principles for distributed systems](distributed-systems.html).

[Service structure and layers](architecture-model.html) explains how Akka applications are structured in different layers.

Akka manages the operational aspects of your application. To learn about how Akka Services run in distributed infrastructure and may span multiple *Regions*, see [Deployment Model](deployment-model.html). Once deployed, Akka’s [Telemetry and Monitoring](../operations/observability-and-monitoring/index.html) provides operational insights into your deployment.

When you are familiar with the main aspects for Akka applications, continue with [Development Process](development-process.html) to understand the steps involved to implement a *Service*.

Components in Akka decouple behavior from execution by using [Delegation with Effects](declarative-effects.html).

A detailed explanation to how *Entities* persist their state, is presented in [Memory models](state-model.html) should you wish to learn more.

Orchestration use cases are often catered for best by considering *Sagas* which is discussed in [Saga patterns](saga-patterns.html).

## <a href="about:blank#_topics"></a> Topics

- [Concepts](concepts.html)
- [Distributed systems](distributed-systems.html)
- [Project structure](architecture-model.html)
- [Deployment model](deployment-model.html)
- [Development process](development-process.html)
- [Delegation with Effects](declarative-effects.html)
- [Memory models](state-model.html)
- [Multi-region operations](multi-region.html)
- [Saga patterns](saga-patterns.html)
- [Endpoints](grpc-vs-http-endpoints.html)
- [Building AI agents](ai-agents.html)
- [Inter-agent communications](inter-agent-comms.html)
- [Access control lists](acls.html)

<!-- <footer> -->
<!-- <nav> -->
[Additional samples](../getting-started/samples.html) [Concepts](concepts.html)
<!-- </nav> -->

<!-- </footer> -->

<!-- <aside> -->

<!-- </aside> -->